#!/bin/sh

SCRIPT=`basename $0`
ROOTPATH="$(dirname "$(readlink -f "$0")")"/..
MEM=256
LOGLEVEL=100
LOGTOCONSOLE=false
LOGPREFIX=KonDadServerConfig
LOGDIR=$ROOTPATH/logs
LOGTHREAD=true
CHARSET=UTF-8
LANGUAGE=de
COUNTRY=de
CONFIGMODE=Server
REVISION=r19412

if test -f /etc/default/kondad; then
    . /etc/default/kondad
fi

if [ ! -z "$1" ]; then
	REVISION=$1
fi

if [ ! -z "$2" ]; then
	JRE=$2
fi

setEnv() {
    if [ $JRE ]; then
        export JAVA_BIN=$JRE/bin/java
    else
    	if [ -d $ROOTPATH/jre21 ]; then
	  	    export JAVA_BIN=$ROOTPATH/jre21/bin/java
	    else
		    export JAVA_BIN=`which java`  
	    fi    
    fi

    export JARS="$ROOTPATH/jars.$REVISION"
    export JARSADDON="$ROOTPATH/jars.addon"    
    
    export CLASSPATH="$JARS/."
    if test -d $JARSADDON; then
    	for fn in $JARSADDON/*.jar; do
        	CLASSPATH="$CLASSPATH:$fn"  
    	done
    fi
    for fn in $JARS/*.jar; do
        CLASSPATH="$CLASSPATH:$fn"  
    done

    if [ $CHARSET ]; then
        OPT="$OPT -Dfile.encoding=$CHARSET"
    fi
    if [ $LANGUAGE ]; then
        OPT="$OPT -Duser.language=$LANGUAGE"
    fi
    if [ $COUNTRY ]; then
        OPT="$OPT -Duser.country=$COUNTRY" 
    fi
    if test -d $JARSADDON; then
        OPT="$OPT -Djava.library.path=$JARSADDON" 
    fi

    export EXEC="cd $ROOTPATH/server;$JAVA_BIN -Xmx"$MEM"m -cp $CLASSPATH -DLogThread=$LOGTHREAD -DLogPrefix=$LOGPREFIX -DLogLevel=$LOGLEVEL -DLogToConsole=$LOGTOCONSOLE -DLogDir=$LOGDIR -DconfigMode=$CONFIGMODE $OPT de/hallobtf/kondad2/setup/DialogController"
}

run() {
    setEnv
    
    eval "$EXEC"    
}

run

exit 0
